

#ifdef MACVERSION 
#include <standard.h>
#endif

#ifdef WIN95VERSION 
#include "standard.h"
#endif

#include "memory.h"
#include "cursor.h"
#include "launch.h"
#include "scrap.h"
#include "shell.h"
#include "shellprivate.h"
#include "langinternal.h"
#include "scripts.h"
#include "process.h"



static boolean flshellactive = true; /*under multifinder, are we in the foreground?*/




boolean shellisactive (void) {
	
	return (flshellactive);
	} /*shellisactive*/


boolean shellactivate (void) {
	
	/*
	2/10/92 dmb: added entrypoint for shellsysverbs and dialog operations
	
	1/22/93 dmb: use langpartialeventloop when a script is running
	
	2.1b12 dmb: don't return quickly if shellactive is true. we may be 
	trying to bring a client process to the front. besided, the overhead 
	of activating an already-active application is small, and this isn't 
	a performance bottleneck anyway.
	*/
	
	/*
	if (flshellactive)
		return (true);
	*/
	
	if (!activateapplication (nil)) /*bring ourselves to the front*/
		return (false);
	
	#ifdef flcomponent
	
	if (fldisableyield)
		return (true);
	
	#endif

#ifdef MACVERSION
	while (!flshellactive) { /*wait 'till we're actually in front*/
		
		if (flscriptrunning)
			langpartialeventloop (osMask | updateMask | activMask);
		else
			shellpartialeventloop (osMask | updateMask | activMask);
		}
#endif
	
	return (true);
	} /*shellactivate*/


static boolean shelljugglervisit (WindowPtr w, ptrvoid refcon) {
	
	shellpushglobals (w);
	
	(*shellglobals.resumeroutine) (flshellactive);
	
	shellpopglobals ();
	
	return (true);
	} /*shelljugglervisit*/
	
	
void shellhandlejugglerevent (void) {
	
	/*
	7/13/90 DW: deactivate the front window when we're swapped into the
	background on a juggler event.  activate it when we're swapped back 
	into the foreground.
	*/
	
	register boolean flresume;
	tyjugglermessage jmsg;
	
	moveleft (&shellevent.message, &jmsg, longsizeof (jmsg));
	
	if (jmsg.eventtype == 1) { /*suspend or resume subevent*/
		
		boolean fl;
		
		flresume = jmsg.flresume; /*copy into register*/
		
		flshellactive = flresume; /*set global*/
		
		if (flresume) { /*force update of mouse cursor*/
		
			setcursortype (cursorisdirty); /*we don't know what state it's in*/
			
			shellforcecursoradjust (); /*make it appear as if mouse moved*/
			}
		
		fl = shellpushfrontglobals ();
		
		if (fl)
			shellactivatewindow (shellwindow, flshellactive);
		
		if (jmsg.flconvertclipboard) {
			
			if (flresume)
				; /*shellreadscrap ()*/ /*12/28/90 dmb: see comment in shellreadscrap*/
			else
				shellwritescrap (anyscraptype);
			}
		
		if (fl)
			shellpopglobals ();
		
		/* 4.0b7 dmb: new feature, just like startup & shutdown scripts */
		if (flresume)
			scriptrunresumescripts ();
		else
			scriptrunsuspendscripts ();
		
		shellvisittypedwindows (-1, &shelljugglervisit, nil); /*send message to all open windows*/
		}
	} /*shellhandlejugglerevent*/
	
	
